/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userprof;

import com.ibm.hwmca.base.userprof.UserProfErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class UpgradeUserProfData
implements UpgradeData,
UserProfErrorIds {
    private static final String TRACE_MASKT = "XSAVUSRT";
    private static final String TRACE_MASKF = "XSAVUSRF";
    private static final String TRACE_MASKD = "XSAVUSRD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "UpgradeUserProfData");
    private static final String PERSISTENT_DATA_STORE_LOCATION = "persist";
    protected String versionNumber;

    public UpgradeUserProfData() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeUserProfData() Constructor");
        this.versionNumber = "00001";
        Trace.trace(TRACE_MASKT, "<- UpgradeUserProfData() Constructor");
    }

    public String getUpgradeDataVersion() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeUserProfData.getUpgradeDataVersion()");
        Trace.trace(TRACE_MASKF, "Version number is : " + this.versionNumber);
        Trace.trace(TRACE_MASKT, "<- UpgradeUserProfData.getUpgradeDataVersion()");
        return this.versionNumber;
    }

    public void saveUpgradeData(OutputStream streamNameOut) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeUserProfData.saveUpgradeData(OutputStream StreamNameOut)");
        Trace.trace(TRACE_MASKF, "Output stream passed in is: " + streamNameOut);
        try {
            Properties props = new Properties();
            props.put("User Profiles", "Save Upgrade Data");
            props.store(streamNameOut, "User Profiles has no data to save");
            Trace.trace(TRACE_MASKF, "Properties file data was put in :" + streamNameOut);
        }
        catch (IOException exc) {
            Trace.trace(TRACE_MASKF, "An IOException occurred" + streamNameOut);
            Trace.trace(TRACE_MASKF, exc);
            UpgradeDataException hexc = new UpgradeDataException(exc);
            hexc.setCriticalDataError();
            new FrameworkLog(_logInfo, 2324, hexc).log();
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeUserProfData.saveUpgradeData(OutputStream StreamNameOut)");
    }

    public void restoreUpgradeData(InputStream streamNameIn, String versionLevel) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeUserProfData.restoreUpgradeData(streamName, version)");
        Trace.trace(TRACE_MASKF, "Input stream passed in is: " + streamNameIn);
        Trace.trace(TRACE_MASKF, "Version level passed in is : " + versionLevel);
        try {
            String path = BaseFileControl.getFilePath(PERSISTENT_DATA_STORE_LOCATION) + "com/ibm/hwmca/fw/managed/User/";
            Trace.trace(TRACE_MASKF, "filepath for persistent user data is " + path);
            this.deleteFileList(path);
        }
        catch (HException exc) {
            Trace.trace(TRACE_MASKF, "An IOException occurred" + streamNameIn);
            Trace.trace(TRACE_MASKF, exc);
            UpgradeDataException hexc = new UpgradeDataException(exc);
            hexc.setCriticalDataError();
            new FrameworkLog(_logInfo, 2325, hexc).log();
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeUserProfData.restoreUpgradeData(streamName, version)");
    }

    private void deleteFileList(String filePath) {
        File dir = new File(filePath);
        File[] delList = dir.listFiles();
        for (int i = 0; i < delList.length; ++i) {
            boolean success = delList[i].delete();
            if (!success) {
                Trace.trace(TRACE_MASKF, "<- User File: " + delList[i] + " could not be Deleted");
                continue;
            }
            Trace.trace(TRACE_MASKF, "<- User File: " + delList[i] + " Deleted");
        }
    }
}

